
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.net.URL;
import javax.swing.filechooser.*;
import java.util.LinkedList;
import java.util.ListIterator;




public final class FastMappingGUI implements ActionListener {
	final static String DEFAULT_MATRIX_FILE="matrix.txt";
	final static int DEFAULT_CHROMOSOMES=1;
	final static double DEFAULT_CORE_LOD = 16.0;
	final static double DEFAULT_LOW_LOD = 2.0;
	final static double DEFAULT_MV = 0.2;
	final static double DEFAULT_11_THRESH = 50.0;
	final static double DEFAULT_121_THRESH = 50.0;
	final static double DEFAULT_13_THRESH = 50.0;
	final static int DEFAULT_SMOOTH_GROUP_THRESH = 100;
	final static double DEFAULT_SINGLETON_THRESH = 0.05;
	final static String BATCH_FILE="fm.bat";

	public String workingDirectory;

	private JFrame mainFrame;
    private JPanel mainPanel;
	JTextField locFile, matrixFile, parametersFile, chromosomes, coreLOD, lowLOD,
					missingValue, oneToOneScreening, codomScreening,oneToThreeScreening,
					smoothGroupThreshold, singletonThreshold;
	JCheckBox order, group, smooth;

	boolean runOrder=false, runGroup=true, runSmooth=true;

	public FastMappingGUI() {
		JFrame.setDefaultLookAndFeelDecorated(true);      
		mainFrame = new JFrame("MarkerView");
		//mainFrame.setSize(new Dimension(1000, 1000));
		mainFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 
		
		//initialization: check directory, tables
		//Dimension screenSize = progress_frame.getToolkit().getScreenSize();
		workingDirectory = System.getProperty("user.dir");
		System.out.println("Working Directory="+workingDirectory);		

		// SET UP MAIN PANELS 
		mainPanel = new JPanel();
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
		mainPanel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));  
		mainFrame.setContentPane(mainPanel);

		locFile = addFileField(locFile, "Loc File     ", "","getLoc");
		matrixFile = addFileField(matrixFile, "Matrix File", DEFAULT_MATRIX_FILE,"getMatrix");
		mainPanel.add(new JLabel("____________________________________________"));
		parametersFile = addFileField(parametersFile, "Load parameters from file:", "","getParameters");

		mainPanel.add(new JLabel("     "));
		group = addCheckBox(group,"Group markers",runGroup,"runGroup");
		chromosomes = addField(chromosomes, "Chromosomes", Integer.toString(DEFAULT_CHROMOSOMES));
		coreLOD = addField(coreLOD, "Core LOD grouping      ", Double.toString(DEFAULT_CORE_LOD));
		lowLOD = addField(lowLOD, "Low LOD for grouping ", Double.toString(DEFAULT_LOW_LOD));

		mainPanel.add(new JLabel("     "));
		missingValue = addField(missingValue, "Missing Value Screening Ratio", Double.toString(DEFAULT_MV));
		oneToOneScreening = addField(oneToOneScreening, "1 : 1 Segregation Chi_square Threshold     ", Double.toString(DEFAULT_11_THRESH));
		codomScreening = addField(codomScreening, "1 : 2 : 1 Segregation Chi_square Threshold", Double.toString(DEFAULT_121_THRESH));
		oneToThreeScreening = addField(oneToThreeScreening, "1 : 3 Segregation Chi_square Threshold     ", Double.toString(DEFAULT_13_THRESH));
		
		mainPanel.add(new JLabel("     "));
		order = addCheckBox(order,"Order individuals",runOrder,"runOrder");
		
		mainPanel.add(new JLabel("     "));
		smooth = addCheckBox(smooth,"Use SMOOTH", runSmooth, "runSmooth");
		smoothGroupThreshold = addField(smoothGroupThreshold, "Minimum Group Size for SMOOTH", Integer.toString(DEFAULT_SMOOTH_GROUP_THRESH));
		singletonThreshold = addField(singletonThreshold, "Singleton Threshold for SMOOTH ", Double.toString(DEFAULT_SINGLETON_THRESH));


		mainPanel.add(new JLabel("____________________________________________"));
		JButton run = new JButton("Run FastMapping");
		run.addActionListener(this);
		mainPanel.add(run);

		//Display the window.
		mainFrame.pack();
		mainFrame.setVisible(true);
	}

	private JTextField addField(JTextField jtf, String label, String defaultString){
		JPanel jp=new JPanel();
		jp.setAlignmentX(JPanel.LEFT_ALIGNMENT);
		jp.setLayout(new BoxLayout(jp, BoxLayout.X_AXIS));
		JLabel jl = new  JLabel(label+"  ");
		jtf=new JTextField(defaultString);
		jtf.setMinimumSize(new Dimension(40,25));
		jtf.setMaximumSize(new Dimension(40,25));
		jp.add(jl);
		jp.add(jtf);
		mainPanel.add(jp);
		return jtf;
	}

	private JTextField addFileField(JTextField jtf, String label, String defaultString, String actionCommand){
		JPanel jp=new JPanel();
		jp.setAlignmentX(JPanel.LEFT_ALIGNMENT);
		jp.setLayout(new BoxLayout(jp, BoxLayout.X_AXIS));
		JLabel jl = new  JLabel(label+"  ");
		jtf=new JTextField(defaultString);
		jtf.setMinimumSize(new Dimension(100,25));
		jtf.setMaximumSize(new Dimension(100,25));
		JButton jb = new JButton("browse");
		jb.setMinimumSize(new Dimension(60,25));
		jb.setMaximumSize(new Dimension(60,25));
		jb.setMargin(new Insets(0,0,0,0));
		jb.setActionCommand(actionCommand);
		jb.addActionListener(this);
		jp.add(jl);
		jp.add(jtf);
		jp.add(jb);
		mainPanel.add(jp);
		return jtf;
	}

	private JCheckBox addCheckBox(JCheckBox jcb, String label, boolean checked, String actionCommand){
		jcb = new JCheckBox(label, checked);
		jcb.setActionCommand(actionCommand);
		jcb.addActionListener(this);
		mainPanel.add(jcb);
		return jcb;
	}

	public void actionPerformed(ActionEvent e) {
		String event = e.getActionCommand();
		System.out.println(event);
		if(event=="getLoc"){
			JFileChooser fc = new JFileChooser(workingDirectory);	
			int returnVal = fc.showOpenDialog(mainFrame);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				if(locFile!=null) locFile.setText(fc.getSelectedFile().getAbsolutePath());
			} 
			else System.out.println("Open command cancelled by user.");
		}
		if(event=="getMatrix"){
			JFileChooser fc = new JFileChooser(workingDirectory);	
			int returnVal = fc.showOpenDialog(mainFrame);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				if(matrixFile!=null) matrixFile.setText(fc.getSelectedFile().getAbsolutePath());
			} 
			else System.out.println("Open command cancelled by user.");
		}
		if(event=="getParameters"){
			JFileChooser fc = new JFileChooser(workingDirectory);	
			int returnVal = fc.showOpenDialog(mainFrame);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				if(matrixFile!=null) getParameters(fc.getSelectedFile());
			} 
			else System.out.println("Open command cancelled by user.");
			
		}
		if(event=="runOrder")
			runOrder=!runOrder;
		if(event=="runGroup")
			runGroup=!runGroup;
		if(event=="runSmooth")
			runSmooth=!runSmooth;
		if(event=="Run FastMapping")
			runFastMapping();
	}

	private void getParameters(File f){
		try{
			String line, parameter,locFileText=locFile.getText();
			BufferedReader br = new BufferedReader(new FileReader(f));
			mainPanel.removeAll();
			locFile = addFileField(locFile, "Loc File     ",locFileText,"getLoc");
			line=br.readLine();	parameter = line.substring(line.indexOf('=')+1).trim().replace("\"","");
			matrixFile = addFileField(matrixFile, "Matrix File", parameter,"getMatrix");

			mainPanel.add(new JLabel("____________________________________________"));
			parametersFile = addFileField(parametersFile, "Load parameters from file:", f.getPath(),"getParameters");

			mainPanel.add(new JLabel("     "));
			group = addCheckBox(group,"Group markers",runGroup,"runGroup");
			line=br.readLine();	parameter = line.substring(line.indexOf('=')+1).trim();
			chromosomes = addField(chromosomes, "Chromosomes", parameter);
			line=br.readLine();	parameter = line.substring(line.indexOf('=')+1).trim();
			coreLOD = addField(coreLOD, "Core LOD grouping      ", parameter);
			line=br.readLine();	parameter = line.substring(line.indexOf('=')+1).trim();
			lowLOD = addField(lowLOD, "Low LOD for grouping ", parameter);

			mainPanel.add(new JLabel("     "));
			line=br.readLine();	parameter = line.substring(line.indexOf('=')+1).trim();
			missingValue = addField(missingValue, "Missing Value Screening Ratio", parameter);
			line=br.readLine();	parameter = line.substring(line.indexOf('=')+1).trim();
			oneToOneScreening = addField(oneToOneScreening, "1 : 1 Segregation Chi_square Threshold     ", parameter);
			line=br.readLine();	parameter = line.substring(line.indexOf('=')+1).trim();
			codomScreening = addField(codomScreening, "1 : 2 : 1 Segregation Chi_square Threshold", parameter);
			line=br.readLine();	parameter = line.substring(line.indexOf('=')+1).trim();
			oneToThreeScreening = addField(oneToThreeScreening, "1 : 3 Segregation Chi_square Threshold     ", parameter);
				
			mainPanel.add(new JLabel("     "));
			line=br.readLine();	parameter = line.substring(line.indexOf('=')+1).trim();
			if(parameter=="1") runOrder=true; else runOrder=false;
			order = addCheckBox(order,"Order individuals",runOrder,"runOrder");
	
			mainPanel.add(new JLabel("     "));
			smooth = addCheckBox(smooth,"Use SMOOTH", runSmooth,"runSmooth");
			smoothGroupThreshold = addField(smoothGroupThreshold, "Minimum Group Size for SMOOTH", Integer.toString(DEFAULT_SMOOTH_GROUP_THRESH));
			singletonThreshold = addField(singletonThreshold, "Singleton Threshold for SMOOTH ", Double.toString(DEFAULT_SINGLETON_THRESH));
		
			mainPanel.add(new JLabel("____________________________________________"));
			JButton run = new JButton("Run FastMapping");
			run.addActionListener(this);
			mainPanel.add(run);
			mainPanel.validate();
			mainPanel.repaint();
			br.close();
		}
		catch(Exception e){
			JOptionPane.showMessageDialog(mainFrame, e.getMessage());
		}
	}


	private void runFastMapping(){
		if(locFile.getText().length()==0) {
			JOptionPane.showMessageDialog(mainFrame, "Please enter a Loc file");
			return;
		}
		if(matrixFile.getText().length()==0) {
			JOptionPane.showMessageDialog(mainFrame, "Please enter a matrix file");
			return;
		}
			
		try{
			PrintWriter pw = new PrintWriter(BATCH_FILE);
			String command = "fast_mapping";
			
			if(runGroup) {
				command+=" -g "+chromosomes.getText()+" "+coreLOD.getText()+" "+lowLOD.getText();
			}
			command+=" -q "+missingValue.getText()+" "+oneToOneScreening.getText()
				+" "+codomScreening.getText()+" "+oneToThreeScreening.getText();

			if(runOrder) command +=" -o";

			if(runSmooth){
				command+=" -s "+smoothGroupThreshold.getText()+" "+singletonThreshold.getText();
			}
			command+=" -m \""+matrixFile.getText()+"\"";
			command+=" \""+locFile.getText()+"\"";
			pw.write(command); pw.println();
			pw.close();
			System.out.println("\""+command+"\"");
		} catch(IOException e) {}
		try{			
			Runtime r = Runtime.getRuntime();
			Process p = r.exec(BATCH_FILE);
			//p.waitFor();
			JOptionPane.showMessageDialog(mainFrame, "Done");

			System.out.println("\nDone");
		}catch(Exception ie) {
			System.err.println("Error getting process:"+ie);
		}
		//new windowFMBatchRun(BATCH_FILE).start();
	}

	/*private class windowFMBatchRun extends Thread {
		public windowFMBatchRun(String str) {
			super(str);
		}
		public void run() {	
			try{ 
				//ProgressThread pt = new ProgressThread(null,"Loading Linkages");
				//pt.run();
				//DataFilesDBI.loadLinkages(new File(getName()),pt);		
				//JOptionPane.showMessageDialog(pt.progress_frame, "Done");
				//pt.finished();
				//updateSelectBar();

				//String command ="\""+System.getProperty("user.dir")+"\\"+BATCH_FILE+"\"";
				Runtime r = Runtime.getRuntime();
				Process p = r.exec(BATCH_FILE);
				//p.waitFor();
				JOptionPane.showMessageDialog(mainFrame, "Done");
				
			} catch (Exception e) {System.err.println("Error getting process:"+e);}			
		}
	}
	*/

/*///////////////
	main
		*/	
   public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
				FastMappingGUI fm = new FastMappingGUI();
            }
        });
    }
}
